/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.graphics2;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics2.Path;
import org.eclipse.swt.widgets.Widget;

public class Surface {
	
	Object jsObject;

	public  native void createSurface (Widget parent, int width, int height) /*-{
		$wnd.dojo.require("dojox.gfx");
		var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
		var surface =new $wnd.dojox.gfx.createSurface(jsParent.domNode, width, height);
		this.@org.eclipse.swt.graphics2.Surface::jsObject = surface;
}-*/;
   
	public native void attachSurface (Widget node) /*-{
	
	}-*/;
	
	public native Object getEventSource() /*-{
	}-*/;
	
	public native void getDimensions() /*-{
	
	}-*/;
	
	public native void setDimensions(int width, int height) /*-{
		
		}-*/;
	
	public native Shape createShape(Shape shape) /*-{
	
	}-*/;
	
	public native Shape createPath(Path path) /*-{
	
	}-*/;
   
	public native Shape createRect(Rect r, boolean fill) /*-{
		$wnd.dojo.require("dojox.gfx");
		
		var rect = {x: r.@org.eclipse.swt.graphics2.Rect::x, 
		y: r.@org.eclipse.swt.graphics2.Rect::y,
		width: r.@org.eclipse.swt.graphics2.Rect::width,
		height: r.@org.eclipse.swt.graphics2.Rect::height, 
		r: r.@org.eclipse.swt.graphics2.Rect::radius};
		
		var surface = this.@org.eclipse.swt.graphics2.Surface::jsObject;
		var shape = surface.createRect(rect);
		
		var tempStroke = r.@org.eclipse.swt.graphics2.Shape::stroke;
		var ar = "";
		$wnd.eval("ar = [];")
		ar[0] = tempStroke.@org.eclipse.swt.graphics2.Stroke::red;
		ar[1] = tempStroke.@org.eclipse.swt.graphics2.Stroke::green;
		ar[2] = tempStroke.@org.eclipse.swt.graphics2.Stroke::blue;

		var jsStroke = {cap: tempStroke.@org.eclipse.swt.graphics2.Stroke::cap,
		color: ar, 
		join: tempStroke.@org.eclipse.swt.graphics2.Stroke::join,
		style: tempStroke.@org.eclipse.swt.graphics2.Stroke::style, 
		type: "stroke",
		width: tempStroke.@org.eclipse.swt.graphics2.Stroke::width};
		
		shape.setStroke(jsStroke);
		if (fill) {
			var tempFill = r.@org.eclipse.swt.graphics2.Shape::fill;
			
			switch (tempFill.@org.eclipse.swt.graphics2.Fill::type) {
				case "color":
				 var ar2 = "";
				 $wnd.eval("ar2 = [];")
				 ar2[0] = tempFill.@org.eclipse.swt.graphics2.Fill::red;
				 ar2[1] = tempFill.@org.eclipse.swt.graphics2.Fill::green;
				 ar2[2] = tempFill.@org.eclipse.swt.graphics2.Fill::blue;
				 shape.setFill(ar2);
				break;
			}
		 }
	}-*/;
	   
	public native Shape createCircle(Circle circle) /*-{
		
	}-*/;
	   
	public native Shape createEllipse(Ellipse ellipse) /*-{
	
	}-*/;
	
	
	public native Shape createLine(Line line) /*-{
	
	}-*/;

	public native Shape createPolyline(Polyline polyline) /*-{
	
	}-*/;
	
	public native Shape createImage(DojoImage dimage) /*-{
		$wnd.dojo.require("dojox.gfx");
		
		var image = {x: dimage.@org.eclipse.swt.graphics2.DojoImage::x, 
		y: dimage.@org.eclipse.swt.graphics2.DojoImage::y,
		width: dimage.@org.eclipse.swt.graphics2.DojoImage::width,
		height: dimage.@org.eclipse.swt.graphics2.DojoImage::height, 
		src: dimage.@org.eclipse.swt.graphics2.DojoImage::src};
		
		var surface = this.@org.eclipse.swt.graphics2.Surface::jsObject;
		var shape = surface.createImage(image);
	}-*/;
	
	public native Shape createText(DojoText text) /*-{
	
	}-*/;
	
	public native Shape createTextPath(DojoTextPath textPath) /*-{
	
	}-*/;
	

   public native void createGroup() /*-{
   }-*/;
	
	public native Surface add(Shape shape) /*-{
	
	}-*/;
   
	public native Surface remove(Shape shape) /*-{
	
	}-*/;
   

	public native Surface clear() /*-{
		$wnd.dojo.require("dojox.gfx");
		var surface = this.@org.eclipse.swt.graphics2.Surface::jsObject;
		surface.clear();
	}-*/;
   

}
